/*******************************************************************************
 * Copyright (c) 2000, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.swt.widgets;

import intrinsic.mx.collections.ArrayCollection;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.*;

public class TreeItem extends Item {
	public ArrayCollection items;
	Tree parent;
	TreeItem parentItem;
	Image [] images;
	String [] strings;
	boolean checked, grayed, cached; 

public TreeItem (Tree parent, int style) {
	this(checkNull(parent), null, style, parent.getItemCount(), true);
}

public TreeItem (Tree parent, int style, int index) {
	this(checkNull(parent), null, style, index, true);
}

public TreeItem (TreeItem parentItem, int style) {
	this(checkNull(parentItem).parent, parentItem, style, parentItem.getItemCount(), true);
}

public TreeItem (TreeItem parentItem, int style, int index) {
	this(checkNull(parentItem).parent, parentItem, style, index, true);
}

TreeItem (Tree parent, TreeItem parentItem, int style, int index, boolean create) {
	super (parent, style);
	this.parent = parent;
	this.parentItem = parentItem;
	if (create) parent.createItem (this, parentItem, index);
}

static TreeItem checkNull (TreeItem item) {
	if (item == null) SWT.error (SWT.ERROR_NULL_ARGUMENT);
	return item;
}

static Tree checkNull (Tree tree) {
	if (tree == null) SWT.error (SWT.ERROR_NULL_ARGUMENT);
	return tree;
}

protected void checkSubclass () {
	if (!isValidSubclass ()) error (SWT.ERROR_INVALID_SUBCLASS);
}

void clear () {
	cached = false;
	text = "";
	image = null;
	strings = null;
	images = null;
	checked = grayed = false;
//	foreground = background = null;
//	cellForeground = cellBackground = null;
//	font = null;
//	cellFont = null;
}

public void clear (int index, boolean all) {
	checkWidget ();
	int count = items.length;
	if (index < 0 || index >= count) SWT.error (SWT.ERROR_INVALID_RANGE);
	TreeItem item = (TreeItem)items.getItemAt(index); 
	item.clear();
	if (all) item.clearAll(true);
	parent.invalidateItem(item, 0);
}

public void clearAll (boolean all) {
	checkWidget ();
	int count = items.length;
	for (int i=0; i<count; i++) {
		clear (i, all);
	}
}

void createWidget() {
	super.createWidget();
	items = new ArrayCollection();
}

void destroyWidget () {
	parent.destroyItem (this);
	releaseHandle ();
}

public Color getBackground () {
	return parent.getBackground();
}

public Color getBackground (int index) {
	return getBackground();
}

public Rectangle getBounds () {
	return null;
}

public Rectangle getBounds (int index) {
	return null;
}

public boolean getChecked () {
	checkWidget ();
	if (!parent.checkData (this, true)) error (SWT.ERROR_WIDGET_DISPOSED);
	if ((parent.style & SWT.CHECK) == 0) return false;
	return checked;
}

public boolean getExpanded () {
	return false;
}

public Font getFont () {
	return parent.getFont();
}

public Font getFont (int index) {
	return getFont();
}

public Color getForeground () {
	return parent.getForeground();
}

public Color getForeground (int index) {
	return getForeground();
}

public boolean getGrayed () {
	return false;
}

public TreeItem getItem (int index) {
	checkWidget ();
	if (!(0 <= index && index < items.length)) error (SWT.ERROR_INVALID_RANGE);
	return (TreeItem)items.getItemAt(index);
}

public int getItemCount () {
	checkWidget();
	if (!parent.checkData (this, true)) error (SWT.ERROR_WIDGET_DISPOSED);
	return items.length;
}

public TreeItem[] getItems () {
	checkWidget ();
	TreeItem[] result = new TreeItem[items.length];
	for (int i = 0; i < result.length; i++) {
		result[i] = (TreeItem)items.getItemAt(i);
	}
	return result;
}

public Image getImage () {
	checkWidget ();
	if (!parent.checkData (this, true)) error (SWT.ERROR_WIDGET_DISPOSED);
	return super.getImage ();
}

public Image getImage (int index) {
	checkWidget ();
	if (!parent.checkData (this, true)) error (SWT.ERROR_WIDGET_DISPOSED);
	if (index == 0) return getImage ();
	if (images != null) {
		if (0 <= index && index < images.length) return images [index];
	}
	return null;
}

public Rectangle getImageBounds (int index) {
	return null;
}

public Tree getParent () {
	checkWidget ();
	return parent;
}

public TreeItem getParentItem () {
	checkWidget ();
	return parentItem;
}

public String getText () {
	checkWidget ();
	if (!parent.checkData (this, true)) error (SWT.ERROR_WIDGET_DISPOSED);
	return super.getText ();
}

public String getText (int index) {
	checkWidget ();
	if (!parent.checkData (this, true)) error (SWT.ERROR_WIDGET_DISPOSED);
	if (index == 0) return getText ();
	if (strings != null) {
		if (0 <= index && index < strings.length) {
			String string = strings [index];
			return string != null ? string : "";
		}
	}
	return "";
}

public Rectangle getTextBounds (int index) {
	return null;
}

public int indexOf (TreeItem item) {
	checkWidget ();
	if (item == null) error (SWT.ERROR_NULL_ARGUMENT);
	if (item.isDisposed ()) error (SWT.ERROR_INVALID_ARGUMENT);
	if (item.parentItem != this) return -1;
//	return parent._indexOf (this, item);
	//TODO
	return 0;
}

void releaseChildren (boolean destroy) {
	if (destroy) {
//		parent.releaseItems (childIds);
		//TODO
	}
	super.releaseChildren (destroy);
}

void releaseHandle () {
	super.releaseHandle ();
	object = null;
	items = null;
	parentItem = null;
	parent = null;
}

void releaseWidget () {
	super.releaseWidget ();
	strings = null;
	images = null;
//	background = foreground = null;
//	font = null;
//	cellBackground = cellForeground = null;
//	cellFont = null;
}

public void removeAll () {
}

public void setBackground (Color color) {
}

public void setBackground (int index, Color color) {
}

public void setChecked (boolean checked) {
}

public void setExpanded (boolean expanded) {
}

public void setFont (Font font) {
}

public void setFont (int index, Font font) {
}

public void setForeground (Color color) {
}

public void setForeground (int index, Color color) {
}

public void setGrayed (boolean grayed) {
}

public void setImage (Image[] images) {
	checkWidget ();
	if (images == null) error (SWT.ERROR_NULL_ARGUMENT);
	for (int i=0; i<images.length; i++) {
		setImage (i, images [i]);
	}
}

public void setImage (int index, Image image) {
	checkWidget ();
	if (image != null && image.isDisposed ()) {
		error(SWT.ERROR_INVALID_ARGUMENT);
	}
//	if (parent.imageBounds == null && image != null) {
//		parent.setItemHeight (image);
//	}
	if (index == 0)  {
		if (image != null && image.type == SWT.ICON) {
			if (image.equals (this.image)) return;
		}
//		width = -1;
		super.setImage (image);
	}
	int count = 1;//Math.max (1, parent.columnCount);
	if (0 <= index && index < count) {
		if (images == null) images = new Image [count];
		if (image != null && image.type == SWT.ICON) {
			if (image.equals (images [index])) return;
		}
		images [index] = image;	
	}
	cached = true;
//	if (index == 0) parent.setScrollWidth (this);
	parent.invalidateItem (this, index);
}

public void setImage (Image image) {
	checkWidget ();
	setImage (0, image);
}

public void setItemCount (int count) {
}

public void setText (String[] strings) {
	checkWidget ();
	if (strings == null) error (SWT.ERROR_NULL_ARGUMENT);
	for (int i=0; i<strings.length; i++) {
		String string = strings [i];
		if (string != null) setText (i, string);
	}
}

public void setText (int index, String string) {
	checkWidget ();
	if (string == null) error (SWT.ERROR_NULL_ARGUMENT);
	if (index == 0) {
		if (string.equals (text)) return;
//		width = -1;
		super.setText (string);
	}
	int count = 1; //Math.max (1, parent.columnCount);
	if (0 <= index && index < count) {
		if (strings == null) strings = new String [count];
		if (string.equals (strings [index])) return;
		strings [index] = string;
	}
	cached = true;
//	if (index == 0) parent.setScrollWidth (this);
	parent.invalidateItem (this, index);
}

public void setText (String string) {
	checkWidget ();
	setText (0, string);
}

}
